package mybeaverbot;

import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.*;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.exceptions.ScriptedAgentException;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import cz.cuni.utils.Config;
import java.io.File;
import java.util.ArrayDeque;
import java.util.HashSet;

/**
 *  NOTE: Class with agent must be marked also in manifest.mf, otherwise IDE don't know, which file it should run.
 *
 *  WARNING: you need to set the path to the planfile, edit getPlanFile() method!
 */
public class Main extends SPoshBot {
    

	private class DIEListener implements RcvMsgListener {
		
		public DIEListener() {
			body.addTypedRcvMsgListener(this, MessageType.BOT_KILLED);
		}
		
		@Override
		public void receiveMessage(RcvMsgEvent e) {
			log.info("The bot was killed!");
			MyBehaviour myBehaviour = (MyBehaviour)behaviour;
			if (myBehaviour != null)
				myBehaviour.resetLogic();
		}
	}
	
	private DIEListener dieListener = new DIEListener();
	
	
	private class KILListener implements RcvMsgListener {
		
		public KILListener() {
			body.addTypedRcvMsgListener(this, MessageType.PLAYER_KILLED);
		}
		
		@Override
		public void receiveMessage(RcvMsgEvent e) {
			log.info("The player was killed!");
			MyBehaviour myBehaviour = (MyBehaviour)behaviour;
			if (myBehaviour != null)
				myBehaviour.playerKilled();
		}
	}
	
	private KILListener kilListener = new KILListener();
	
	
	/** Creates a new instance of agent. */
    public Main() throws ScriptedAgentException {
        super();        
    }
    
	@Override
    protected JavaBehaviour getBehaviour() {
        return new MyBehaviour("MyBehaviour", this.log, this);
    }
    
	@Override
    protected String getPlanFile() {
        return Config.getProjectsPath()+File.separator+"MartinKrulis-DM-BeaverBot"+File.separator+"src"+File.separator+"mybeaverbot"+File.separator+"sposhPlan.lap";
    }
    
	@Override
    protected void prePrepareAgent()  throws PogamutException {        
        super.prePrepareAgent();
        /* Prepares agent logic to run - like initializing neural networks etc.
        not for establishing communication! */
    }
    
	@Override
	protected void postPrepareAgent() throws PogamutException
	{
		super.postPrepareAgent();
		/* Prepare logic according to information from gathered from startCommunication
		like choosing plan/parameters according to game type. */
		
		// Initialize map in the behaviour class using Floyd-Warshall algorithm.
		MyBehaviour myBehaviour = (MyBehaviour)this.behaviour;
		myBehaviour.initializeMap();
		getBody().configureVisionTime(0.2);
		this.getBody().initializer.setBotSkillLevel(3);
	}

	@Override
    protected void shutdownAgent() throws PogamutException {        
        super.shutdownAgent();
        /* Clean up after the end of simulation of agent */
    }
    
    public static void main(String[] args) {
    }
}
